/*

Isolate Inverse Selection Script File
Created:  		July 31 2001
Author:   Pete Samson


Isolate Inverse Selection Functions
This script creates functions for Isolating  unselected geometery and 
basically inverses the selection and call the Isolate Selection script 
***********************************************************************************************/

MacroScript Isolate_Inverse_Selection
Category:~ISOLATE_INVERSE_SELECTION_CATEGORY~ 
internalCategory:"Tools" 
ToolTip:~ISOLATE_INVERSE_SELECTION_TOOLTIP~ 
buttontext:~ISOLATE_INVERSE_SELECTION_BUTTONTEXT~ 
Icon:#("ViewPortNavigationControls",7) 
SilentErrors:True
(

	on isEnabled return(selection.count > 0 and (subObjectLevel == 0 or subObjectLevel == undefined))
			
	on execute do with undo off
	(
		-- saves the current selection filter (all, lights, geometry etc...)
		local SavedSelectionFilter
		SavedSelectionFilter = GetSelectFilter()

		--set the selection filter to all in order to provide an efficient Isolation tool
		SetSelectFilter 1
		if (isSelectionFrozen() == true)do thawSelection() ---pfb feb 10 2003, tool was failing when selection is locked
		max select invert
		IsolateSelection.EnterIsolateSelectionMode()
		max select none
		
		--restores the previously saved selection filter
		SetSelectFilter SavedSelectionFilter
	)
)

